// src/config/index.ts

/**
 * The base URL for the Laravel API.
 * Defaults to a placeholder if not set in environment variables.
 */
export const API_BASE_URL = process.env.NEXT_PUBLIC_API_BASE_URL || "https://try.hussainwh.info/api";

export const APP_NAME = "InteractiveResume";

// URL for server-side components to call the internal proxy or for other absolute URL needs
// For local dev, this defaults to http://localhost:3000 (or your Next.js port).
// Set NEXT_PUBLIC_APP_URL in .env.local or your deployment environment for production.
export const NEXT_APP_BASE_URL = process.env.NEXT_PUBLIC_APP_URL || (typeof window !== 'undefined' ? window.location.origin : 'http://localhost:3000');

/**
 * The relative path for the Next.js API proxy route.
 */
export const PROXY_PATH = "/api/proxy";
