
// src/components/AdSensePlaceholder.tsx

interface AdSensePlaceholderProps {
  slot: string;
  className?: string;
}

export const AdSensePlaceholder = ({ slot, className }: AdSensePlaceholderProps) => (
  <div className={`my-8 p-4 text-center bg-muted text-muted-foreground rounded-lg ${className}`}>
    [Google AdSense Ad - Slot: {slot}]<br />
    <span className="text-xs">(This is a placeholder for an ad unit)</span>
  </div>
);

export default AdSensePlaceholder;
