# **App Name**: InteractiveResume

## Core Features:

- Scroll-driven Navigation: Single-page layout with a sticky header/sidebar and smooth scrolling to different sections (Hero, About, Tech Stack, Experience, Projects, Education, Testimonials, Contact, and Footer).
- Project Showcase: Display key projects as interactive cards, with title, description, tech stack, outcome, and a link to the live demo or GitHub repository.
- Resume Download: Generate a downloadable PDF version of the resume using react-to-print, hiding non-essential elements for a clean print layout.
- Animated Backgrounds: Incorporate subtle animated backgrounds or particle effects to enhance visual appeal without cluttering the design.
- Contact Form: Implement a contact form that allows visitors to send messages via Netlify Forms or EmailJS.

## Style Guidelines:

- Mobile-first responsive design using Tailwind CSS grid and flexbox to ensure content stacks naturally on small screens.
- Light/Dark theme support with automatic switching based on system preferences (using Tailwind's dark: variants and local storage persistence).
- Legible sans-serif fonts with sufficient contrast, ensuring a smooth experience for keyboard navigation and screen readers.
- Framer Motion to add fade/slide-in animations as elements enter the viewport.
- Accent color: Teal (#008080) to highlight interactive elements and call-to-actions.